import math

def mergeSort(items):
    print('.....mergeSort() wywołana z argumentem:', items)

    # PRZYPADEK BAZOWY — Tablica pusta i tablica jednoelementowa są z definicji posortowane: 
    if len(items) == 0 or len(items) == 1: # PRZYPADEK BAZOWY
        return items

    # PRZYPADEK REKURENCYJNY — Przekazuję lewą i prawą połowę do wywołania mergeSort():
    # Zaokrąglanie współrzędnej punktu środkowego (tablica ma nieparzystą długość):
    iMiddle = math.floor(len(items) / 2)

    print('................Podzielono na:', items[:iMiddle], 'i',
    items[iMiddle:])

    left = mergeSort(items[:iMiddle])
    right = mergeSort(items[iMiddle:])

    # PRZYPADEK BAZOWY — Zwraca scalone posortowane dane:
    # W tym punkcie lista `left` i lista `right` powinny być posortowane,
    # możemy je zatem scalić w jedną posortowaną listę
    sortedResult = []
    iLeft = 0
    iRight = 0
    while (len(sortedResult) < len(items)):
        # Dodawanie mniejszej z dwóch wartości do listy `sortedResult`
        if left[iLeft] < right[iRight]:
            sortedResult.append(left[iLeft])
            iLeft += 1
        else:
            sortedResult.append(right[iRight])
            iRight += 1

        # Jeśli jeden z wskaźników dotarł do końca listy, 
        # to do `sortedResult` dodajemy pozostałą część drugiej listy
        if iLeft == len(left):
            sortedResult.extend(right[iRight:])
            break
        elif iRight == len(right):
            sortedResult.extend(left[iLeft:])
            break

    print('Dwie połowy zostały połączone w:', sortedResult)

    return sortedResult # Zwrócenie posortowanej wersji listy `items`

myList = [2, 9, 8, 5, 3, 4, 7, 6]
myList = mergeSort(myList)
print(myList)